from django.shortcuts import render
from django.http import HttpResponse
from django.http import HttpResponseRedirect
from django.shortcuts import render
from .forms import UploadFileForm
from .models import ImageModel
from django.conf import settings
from app.classifier import classifier
# from PIL import Image, ImageOps,ImageFilter
import random 
import os.path

from django.shortcuts import render
from django.http import HttpResponse
from django.core.files.storage import FileSystemStorage
from django.views.decorators.csrf import csrf_exempt
from django.conf import settings
from django.core.files import File
from django.core.files.base import ContentFile
from django.core.files.temp import NamedTemporaryFile
from urllib.request import urlopen
from django.core.files.storage import default_storage


def camera(request):
    if request.method == 'POST':
        print("Hello..")
        image_path = request.POST["src"]
        image = NamedTemporaryFile()
        urlopen(image_path).read()
        image.write(urlopen(image_path).read())
        image.flush()
        image = File(image)
        name = str(image.name).split('\\')[-1]
        name += '.jpg'  # store image in jpeg format
        image.name = name
        with open('image.txt', 'w+') as file:
            file.write(str(name))
        default_storage.save('/images', ContentFile(urlopen(image_path).read()))
        return HttpResponse('Done!')
    return render(request, 'capture.html')

def index(request):
    context ={}
    # if this is a POST request we need to process the form data
    if request.method == 'POST':
        # create a form instance and populate it with data from the request:
        form = UploadFileForm(request.POST, request.FILES)

        if form.is_valid():
            # print(request.FILES['File'])
            name = handle_uploaded_file(request.FILES['File'])
            outputfilename = "static/images/"+ name
            prediction = process_upload(name)

            sign =prediction[0]
            prob= prediction[1]
            # print("Root Path: " , settings.ROOT_PATH)
            return render(request, 'result.html',{'file': outputfilename, 'sign': sign, 'probability': prob})

    # if a GET (or any other method) we'll create a blank form
    else:
        form = UploadFileForm()
    #return render(request, 'capture.html', {'form': form})
    return render(request, 'index.html', {'form': form})

def handle_uploaded_file(f):
    context={}
    uploadfilename= os.path.abspath(os.path.dirname(__file__))+ '/static/images/'+f.name
    with open(uploadfilename, 'wb+') as destination:
        for chunk in f.chunks():
            destination.write(chunk)
    return f.name

def process_upload(f):
    c = classifier()
    return c.predict(f)